/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.ingredient;

import javax.annotation.Nonnull;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class IngredientFluidItem
implements IIngredient<ItemStack> {
    private final FluidStack stack;

    public IngredientFluidItem(@Nonnull Fluid fluid, int amount) {
        this(new FluidStack(fluid, amount));
    }

    public IngredientFluidItem(@Nonnull FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean test(ItemStack input) {
        FluidStack result = FluidUtil.getFluidContained((ItemStack)input);
        return result != null && result.amount >= this.stack.amount && result.getFluid() == this.stack.getFluid();
    }

    @Override
    public ItemStack consume(ItemStack input) {
        IFluidHandler cap = (IFluidHandler)input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (cap != null) {
            cap.drain(this.stack.copy(), true);
        }
        return input;
    }

    @Override
    public int getAmount() {
        return this.stack.amount;
    }

    public FluidStack getFluid() {
        return this.stack.copy();
    }
}

